// auditory thermometer
// oswald berthold, 10/2007
// nach http://www.ski.org/Rehab/sktf/vol07no1Winter1986.html#general
// requires an OSC message /temperature,sensor-index,temp-in-degree-celsius
// to be sent to sclang

// init
(
Server.default = s = Server.local;
s.boot;
g = SwingOSC.default;
g.boot;
)

// temperatur ton
(
SynthDef(\at, {
	|base(200), temp(0), span(1), lagtime(0), amp(0.1)|
	var out;
	out = SinOsc.ar(Lag.kr(temp * span + base, lagtime), 0, amp);
	Out.ar(0, out);
}).send(s);
)

x = Synth(\at);
x.set(\amp, 0.3);
x.set(\lagtime, 1);
x.set(\temp, 20.0.rand);
x.set(\span, 10);
// referenzton


// the GUI
(
var win, cb;
var tslb, tsts, tstb, tstt, tsss, tssb, tsst;
var rslb, rsbs, rstb, rsbt, rsvs, rsvt, rsvb;
var tempsynth, refsynth, base, span, tempmax;
var res;

base = 200;
span = 20;
tempmax = 40;

tempsynth = Synth(\at, [\base, base, \span, span]);
refsynth = Synth(\at, [\base, base]);

win = GUI.window.new(\AuditoryThermometer, Rect(0, 0, 200, 200));
// tempsynth
tslb = GUI.staticText.new(win, Rect(10, 10, 200, 20)).string = 'Temperature Synth';

tsts = GUI.slider.new(win, Rect(10, 30, 200, 30));
tstb = GUI.numberBox.new(win, Rect(220, 30, 50, 20)).value = 0;
tstt = GUI.staticText.new(win, Rect(280, 30, 200, 20)).string = 'Temperature Normalized 0-1';

tsss = GUI.slider.new(win, Rect(10, 60, 200, 30)).value = span/100;
tssb = GUI.numberBox.new(win, Rect(220, 60, 50, 20)).value = span;
tsst = GUI.staticText.new(win, Rect(280, 60, 200, 20)).string = 'Temperature Modulation Range';

// refsynth
rslb = GUI.staticText.new(win, Rect(10, 100, 200, 20)).string = 'Reference Synth';

rsbs = GUI.slider.new(win, Rect(10, 130, 200, 30));
rstb = GUI.numberBox.new(win, Rect(220, 130, 50, 20)).value = 0;
rsbt = GUI.staticText.new(win, Rect(280, 130, 200, 20)).string = 'Reference Temperature';

rsvs = GUI.slider.new(win, Rect(10, 170, 200, 30));
rsvb = GUI.numberBox.new(win, Rect(220, 170, 50, 20)).value = 0;
rsvt = GUI.staticText.new(win, Rect(280, 170, 200, 20)).string = 'Reference Volume';

cb = GUI.button.new(win, Rect(10, 210, 90, 30));
cb.states = [["Stop + Close"]];
cb.action = {|but|
	but.value.postln;
	if(but.value == 0, {
		tempsynth.free;
		refsynth.free;
		res.remove;
		win.close;
	});
};

tsts.action = {|sl|
	tempsynth.set(\temp, sl.value);
	tstb.value = sl.value;
};

tsss.action = {|sl|
	span = sl.value * 100;
	tempsynth.set(\span, span);
	tssb.value = span;
};

rsbs.action = {|sl|
	var val = sl.value * 100 + 200;
	refsynth.set(\base, val);
	rstb.value = val - base / span * tempmax;
};

rsvs.action = {|sl|
	refsynth.set(\amp, sl.value);
	rsvb.value = sl.value;
};

res = OSCresponder(nil, "/temperature", {
	|t, r, m, a|
	// range: 0 - 40 Grad
	//m.postln;
	tsts.valueAction = m[2] / tempmax;
	//tstb.value = m[2] / tempmax;
});
res.add;

win.front;
)